
// SC510Dlg.h : header file
//

#pragma once

#include "ChannelWindow.h"

#include "SetupDlg.h"

// CSC510Dlg dialog
class CSC510Dlg : public CDialogEx
{
// Construction
public:
	CSC510Dlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	enum { IDD = IDD_SC510_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support


// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnDestroy();
	afx_msg void OnPaint();
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()

public:

	static CSC510Dlg *	m_pSC510Dlg;

	ULONG				m_nWndState;

	LONG				m_nCurSelectChannelNumber;

	LONG				m_nAudioPlayChannel;

	BOOL				m_bIsShareRecord;

	BOOL				m_bShareSupportGPU1_1;

	CSetupDlg			m_oSetupDialog;	

	CChannelWindow		m_oChannelWindows_LIVE[ DEFAULT_MAX_CHANNEL_NUM ];

	CChannelWindow		m_oChannelWindows_BK[ DEFAULT_MAX_CHANNEL_NUM ];

	CChannelWindow		m_oCloneWindows[ DEFAULT_MAX_CHANNEL_NUM ];

	CRect				m_rect_slipts_display[ DEFAULT_MAX_CHANNEL_NUM ];

	CRect				m_rect_slipts_display_clone[ DEFAULT_MAX_CHANNEL_NUM ];

	PVOID 				m_hVideoDevice[ DEFAULT_MAX_CHANNEL_NUM ];

	PVOID				m_hCloneCapDev[ DEFAULT_MAX_CHANNEL_NUM ];

	ULONG				m_nVideoWidth[ DEFAULT_MAX_CHANNEL_NUM ];

	ULONG				m_nVideoHeight[ DEFAULT_MAX_CHANNEL_NUM ];

	BOOL				m_bVideoIsInterleaved[ DEFAULT_MAX_CHANNEL_NUM ];

	double				m_dVideoFrameRate[ DEFAULT_MAX_CHANNEL_NUM ];
	
	BOOL				m_bNoSignal[ DEFAULT_MAX_CHANNEL_NUM ];

	BOOL				m_bVideoDeinterlaceEnable;

	ULONG				m_nAudioChannels[ DEFAULT_MAX_CHANNEL_NUM ];

	ULONG				m_nAudioBitsPerSample[ DEFAULT_MAX_CHANNEL_NUM ];

	ULONG				m_nAudioSampleFrequency[ DEFAULT_MAX_CHANNEL_NUM ];

	ULONG				m_nSharpness[ DEFAULT_MAX_CHANNEL_NUM ];

	ULONG				m_nSaturation[ DEFAULT_MAX_CHANNEL_NUM ];

	ULONG				m_nHue[ DEFAULT_MAX_CHANNEL_NUM ];

	ULONG				m_nConstrast[ DEFAULT_MAX_CHANNEL_NUM ];

	ULONG				m_nBrightness[ DEFAULT_MAX_CHANNEL_NUM ];

	BOOL				m_bShareRecordCH[ DEFAULT_MAX_CHANNEL_NUM ];

	CString				m_strFormatChangedOutput[ DEFAULT_MAX_CHANNEL_NUM ];

	BOOL				m_bSupportGPU1_1, m_bIsRecord1_1, m_bSupportGPU1_2, m_bIsRecord1_2, m_bSupportGPU2_1, m_bIsRecord2_1, m_bSupportGPU2_2, m_bIsRecord2_2; 

	BOOL				m_bSupportGPU3_1, m_bIsRecord3_1, m_bSupportGPU3_2, m_bIsRecord3_2, m_bSupportGPU4_1, m_bIsRecord4_1, m_bSupportGPU4_2, m_bIsRecord4_2;

public:

	BOOL				HwUninitialize();

	BOOL				HwInitialize();	

	CString				GetWorkingPath(CString strWorkFile);

	CRect				GetSplitWndPos_SC510DLG( ULONG nChannelNumber, ULONG nGridDivisions, ULONG nRendererWidth, ULONG nRendererHeight );

	BOOL				OnLButtonDblClk_ChannelWindow( ULONG nChannelNum, UINT nFlags, CPoint point );

	BOOL				OnButtonFileRecording_FileRecordDialog();

	BOOL				OnButtonShareRecording_FileRecordDialog();
	
	BOOL				OnButtonVideoInput_SetupDialog();

	BOOL				OnButtonAudioInput_SetupDialog();

	BOOL				OnButtonVideoQuality_SetupDialog();

	BOOL				OnButtonSnapshotJPG_SetupDialog();

	BOOL				OnButtonSnapshotBMP_SetupDialog();

	BOOL				OnCheckGpuSupport_SetupDialog();

	BOOL				OnCheckAutoDeinterlace_SetupDialog();

	BOOL				OnCheckShowCloneVideo_SetupDialog();	
};
